<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Under Review - Flipkart</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f1f3f6;
            color: #212121;
            line-height: 1.6;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
        }
        
        .container {
            max-width: 600px;
            width: 100%;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.16);
            overflow: hidden;
        }
        
        .header {
            background: #2874f0;
            color: white;
            padding: 18px 24px;
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .logo {
            font-size: 26px;
            font-weight: bold;
            display: flex;
            align-items: center;
        }
        
        .logo span {
            color: #ffe500;
            margin-left: 2px;
        }
        
        .logo i {
            margin-right: 8px;
            font-size: 28px;
        }
        
        .header-text {
            font-size: 16px;
            margin-left: auto;
            opacity: 0.9;
        }
        
        .content {
            padding: 28px;
        }
        
        .status-card {
            background: #fff8e1;
            border-left: 5px solid #ffc107;
            padding: 20px;
            margin-bottom: 28px;
            display: flex;
            align-items: center;
            border-radius: 6px;
        }
        
        .status-icon {
            color: #ff9800;
            font-size: 28px;
            margin-right: 20px;
        }
        
        .status-text h2 {
            color: #f57c00;
            margin-bottom: 6px;
            font-size: 22px;
        }
        
        .status-text p {
            font-size: 16px;
            color: #704c0b;
        }
        
        .order-info {
            background: #f9f9f9;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 28px;
            border: 1px solid #e8e8e8;
        }
        
        .info-title {
            font-size: 18px;
            font-weight: 600;
            color: #2874f0;
            margin-bottom: 16px;
            padding-bottom: 8px;
            border-bottom: 1px dashed #ccc;
        }
        
        .info-row {
            display: flex;
            margin-bottom: 14px;
        }
        
        .info-label {
            width: 160px;
            color: #666;
            font-weight: 500;
        }
        
        .info-value {
            flex: 1;
            font-weight: 500;
            color: #333;
        }
        
        .pending-id {
            background: #f0f7ff;
            padding: 16px 20px;
            border-radius: 8px;
            font-family: monospace;
            font-size: 16px;
            letter-spacing: 1.2px;
            margin: 20px 0;
            border-left: 4px solid #2874f0;
            color: #1565c0;
            font-weight: 600;
            text-align: center;
            word-break: break-all;
        }
        
        .timer {
            background: linear-gradient(to right, #e3f2fd, #bbdefb);
            padding: 20px;
            text-align: center;
            border-radius: 10px;
            margin: 28px 0;
            border: 1px solid #bbdefb;
        }
        
        .timer-text {
            font-size: 17px;
            color: #1565c0;
            margin-bottom: 12px;
            font-weight: 500;
        }
        
        .countdown {
            font-size: 32px;
            font-weight: bold;
            color: #0d47a1;
            font-family: 'Courier New', monospace;
        }
        
        .help-section {
            margin-top: 28px;
            padding-top: 20px;
            border-top: 1px dashed #e0e0e0;
        }
        
        .help-title {
            font-size: 18px;
            font-weight: 600;
            margin-bottom: 14px;
            color: #2874f0;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .help-content {
            font-size: 15px;
            color: #616161;
            line-height: 1.7;
        }
        
        .contact {
            margin-top: 12px;
            font-weight: 500;
            background: #f9f9f9;
            padding: 12px;
            border-radius: 6px;
            font-size: 14px;
        }
        
        .footer {
            background: #f1f3f6;
            padding: 20px 24px;
            text-align: center;
            font-size: 13px;
            color: #878787;
            border-top: 1px solid #e0e0e0;
        }
        
        .highlight {
            color: #2874f0;
            font-weight: 500;
        }
        
        .note {
            background: #fffde7;
            padding: 16px 20px;
            border-radius: 8px;
            font-size: 15px;
            margin: 20px 0;
            border-left: 4px solid #ffd600;
            display: flex;
            align-items: flex-start;
            gap: 10px;
        }
        
        .note i {
            color: #f57c00;
            font-size: 18px;
            margin-top: 2px;
        }
        
        .payment-method {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-top: 4px;
        }
        
        .payment-icon {
            width: 40px;
            height: 40px;
            background: #f5f5f5;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 20px;
            color: #2874f0;
            border: 1px solid #e0e0e0;
        }
        
        @media (max-width: 640px) {
            .container {
                margin: 0;
                border-radius: 0;
            }
            
            body {
                padding: 0;
            }
            
            .info-row {
                flex-direction: column;
                margin-bottom: 16px;
            }
            
            .info-label {
                width: 100%;
                margin-bottom: 4px;
                font-size: 14px;
            }
            
            .header {
                padding: 14px 20px;
            }
            
            .content {
                padding: 20px;
            }
            
            .status-card {
                padding: 16px;
            }
            
            .pending-id {
                font-size: 14px;
                padding: 12px 16px;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <div class="logo">
                <i class="fas fa-shopping-cart"></i>
                Flipkart<span>.</span>
            </div>
            <div class="header-text">Secure Payment Gateway</div>
        </div>
        
        <div class="content">
            <div class="status-card">
                <div class="status-icon">
                    <i class="fas fa-clock"></i>
                </div>
                <div class="status-text">
                    <h2>Payment Under Review</h2>
                    <p>Your payment is pending and will be reviewed within 30 minutes</p>
                </div>
            </div>
            
            <div class="order-info">
                <div class="info-title">
                    <i class="fas fa-info-circle"></i> Order Details
                </div>
                <div class="info-row">
                    <div class="info-label">Order ID:</div>
                    <div class="info-value">ODFLP987654321</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Transaction ID:</div>
                    <div class="info-value">TXNFLP7894561230</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Amount:</div>
                    <div class="info-value">₹99.00</div>
                </div>
                <div class="info-row">
                    <div class="info-label">Payment Method:</div>
                    <div class="info-value">
                        <div>UPI</div>
                        <div class="payment-method">
                            <div class="payment-icon">
                                <i class="fas fa-mobile-alt"></i>
                            </div>
                            <div>UPI Transaction</div>
                        </div>
                    </div>
                </div>
                <div class="info-row">
                    <div class="info-label">Date & Time:</div>
                    <div class="info-value" id="datetime">25 October 2023, 14:35 IST</div>
                </div>
            </div>
            
            <div class="pending-id">
                PENDING ID: <span id="pendingId">FLP-PND-7890-4561-2378-9012</span>
            </div>
            
            <div class="note">
                <i class="fas fa-info-circle"></i> 
                <div>Your order will be confirmed once the payment is verified. You will receive an email and SMS confirmation. If money was deducted, it will be refunded within 7-10 business days if order is not confirmed.</div>
            </div>
            
            <div class="timer">
                <div class="timer-text">Estimated review completion in:</div>
                <div class="countdown">29:45</div>
            </div>
            
            <div class="help-section">
                <div class="help-title">
                    <i class="fas fa-headset"></i> Need Help?
                </div>
                <div class="help-content">
                    <p>If you have any questions about your payment, please contact our 24x7 customer support.</p>
                    <p class="contact">
                        <i class="fas fa-envelope"></i> Email: support@flipkart.com | 
                        <i class="fas fa-phone"></i> Phone: 1800 208 9898
                    </p>
                </div>
            </div>
        </div>
        
        <div class="footer">
            <p>© 2025 Flipkart. All rights reserved. Please do not share your Order ID, Transaction ID or Pending ID with anyone.</p>
        </div>
    </div>

    <script>
        // Generate random pending ID
        function generatePendingId() {
            const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            let result = 'FLP-PND-';
            for (let i = 0; i < 4; i++) {
                for (let j = 0; j < 4; j++) {
                    result += chars.charAt(Math.floor(Math.random() * chars.length));
                }
                if (i < 3) result += '-';
            }
            return result;
        }
        
        // Update datetime
        function updateDateTime() {
            const now = new Date();
            const options = { day: 'numeric', month: 'long', year: 'numeric', hour: '2-digit', minute: '2-digit' };
            document.getElementById('datetime').textContent = now.toLocaleDateString('en-IN', options) + ' IST';
        }
        
        // Countdown timer
        function startTimer(duration, display) {
            let timer = duration, minutes, seconds;
            setInterval(function () {
                minutes = parseInt(timer / 60, 10);
                seconds = parseInt(timer % 60, 10);
                
                minutes = minutes < 10 ? "0" + minutes : minutes;
                seconds = seconds < 10 ? "0" + seconds : seconds;
                
                display.textContent = minutes + ":" + seconds;
                
                if (--timer < 0) {
                    timer = 0;
                }
            }, 1000);
        }
        
        window.onload = function () {
            // Set random pending ID
            document.getElementById('pendingId').textContent = generatePendingId();
            
            // Update date/time
            updateDateTime();
            
            // Start countdown timer
            const thirtyMinutes = 30 * 60;
            const display = document.querySelector('.countdown');
            startTimer(thirtyMinutes - 15, display); // Starting at 29:45
        };
    </script>
</body>
</html>