<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Payment Page</title>
  <style>
    body {
      font-family: 'Roboto', Arial, sans-serif;
      margin: 0;
      padding: 0;
      background-color: #f1f3f6;
    }

    header {
      display: flex;
      align-items: center;
      justify-content: space-between;
    }

    h2 {
      margin: 0;
      text-align: center;
      font-size: 24px;
    }

    header nav {
      display: flex;
      align-items: center;
    }

    header nav a {
      color: #fff;
      text-decoration: none;
      margin-left: 20px;
      font-size: 14px;
    }

    main {
      max-width: 800px;
      margin: 2px auto;
      padding: 2px;
      background-color: #fff;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    section {
      margin-bottom: 20px;
    }

    label {
      font-weight: bold;
    }

    .qr img {
      width: 60%;
      margin-bottom: 20px;
    }

    input[type="text"],
    input[type="email"],
    input[type="number"] {
      width: 100%;
      padding: 10px;
      margin-top: 5px;
      margin-bottom: 15px;
      border: 1px solid #ccc;
      border-radius: 5px;
      box-sizing: border-box;
    }

    .button-container {
      text-align: center;
    }

    button[type="submit"] {
      background-color: #fb641b;
      color: #fff;
      padding: 10px 20px;
      border: none;
      border-radius: 2px;
      cursor: pointer;
    }

    button[type="submit"]:hover {
      background-color: #e5641b;
    }

    table {
      width: 100%;
      border-collapse: collapse;
    }

    table, th, td {
      border: 1px solid #ccc;
    }

    th, td {
      padding: 10px;
      text-align: left;
    }

    footer {
      position: relative;
      width: 100%;
      margin-top: 0px;
      text-align: center;
    }

    footer img {
      width: 100%;
      object-fit: cover;
    }

    @media screen and (max-width: 600px) {
      main {
        padding: 10px;
      }

      header {
        flex-direction: column;
        align-items: flex-start;
      }

      header nav {
        margin-top: 10px;
      }
    }
  </style>
</head>
<body>
  <header>
    <img src="InShot_20250420_164542260.jpg" alt="" width="100%">
  <main>
    <section>
    <h2> </h2>
    <br>
    <br><br><br><br><br>
      <h2>Scan QR Code to Pay</h2>
      <br>      
      <center>
        <div id="qrContainer" class="qr">
          <img src="" class="qr-image" alt="QR Code">
        </div>
      </center>
      <h2>Order Amount ₹645</h2>
    </section>

    <section>
      <h2>Enter UTR Number</h2>
      <form action="thanks.php" method="post">
        <div class="button-container">
          <input type="number" id="utr_number" name="utr_number" placeholder="Enter Your UTR No." required minlength="10">
          <br>
          <button type="submit">Submit UTR</button>
        </div>
      </form>
    </section>

    <section>
      <h2>Instructions for Payment</h2>
      <table>
        <tr><td>Step 1:</td><td>Scan the QR code using your mobile banking app.</td></tr>
        <tr><td>Step 2:</td><td>Enter the payment amount.</td></tr>
        <tr><td>Step 3:</td><td>Enter your UTR number in the payment details.</td></tr>
        <tr><td>Step 4:</td><td>Complete the payment.</td></tr>
      </table>
    </section>
  </main>

  <footer>
    <img src="segzx.png" alt="Footer Image">
  </footer>

  <script>
function generateQRCode(amount) {
  var upiPaymentUrl = `upi://pay?pa=paytm.s202pq8@pty&tr=Paytm&mc=0000&tn=OrderId-Fk280273017&pn=Flipkart&am=${amount}&cu=INR`;
  var qrCodeUrl = `https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=${encodeURIComponent(upiPaymentUrl)}`;
  var qrCodeImage = document.querySelector('.qr img');
  if (qrCodeImage) {
    qrCodeImage.src = qrCodeUrl;
  }
}

window.onload = function () {
  var urlParams = new URLSearchParams(window.location.search);
  var amount = urlParams.get('price') || '99';
  generateQRCode(amount);
};
  </script>

  <script defer src="https://static.cloudflareinsights.com/beacon.min.js/vcd15cbe7772f49c399c6a5babf22c1241717689176015" crossorigin="anonymous"></script>
</body>
</html>
